; Assembly source code of "Fun With Vectors - Ziggy
; (1985)(Richard Degler)(PD)(proto)[update 3].bin"
;
; CPU Type: Z80 - for The Bally Professional Arcade
;
; Programed and commented by: Richard C. Degler
; From Scratch with a whole lot of hand editing!
;
; Re-created with dZ80 1.50 and commented by: RCD
;
; on Tuesday, 04 of November 2008 at 05:13 AM
; Assembles correctly with: Zmac -i FUNWIT~4.ASM
;


; note: Original programming done using an R&L 64kRAM board,
; BlueRamBasic 1.1 copy utilities and a MicroSwitch keyboard.
; NO Assembler - all Machine Code from a Z80 reference card!
; Comments were on paper listing, in decimal, changed to HEX
; & variables given names. [new comments in square brackets]
; UPDATES - tested on the MESS Bally / Astrocade emulator :
; 1: 11/9/08 removed L20xx labels, filler, and other changes
; 2: 11/10/08 Deltas now 3/4 old plus 1/4 new and Timing Test
; 3: 11/11/08 added mirror image and Deltas now 7/8 plus 1/8
;


; Notes on "Fun with Vectors - Ziggy" from circa 1985:
;
;
; Moves one pixel per sixtieth of a second by Joystick ONE
; and continues in the same direction with rubber walls on
; trigger in.
;
; VECT repeats until vbTIMB = 0, adding delta to X and Y POS.
; words (if vbSTAT bit 7 is set.)  Original vbTIMB returns
; in C and Zero Flag is set if no move made.
;
; VWRITR draws pattern displaced from high bytes of POSition
; and uses vbMREG Magic Value.  The Absolute Address is ret-
; urned in DE, which must be stored in vbOADD for VBLANK use.
; vbBLNK gets set.
;
; VBLANK blanks a box beginning at vbOADD (flipped if vbMREG
; bit 6 set) - but only if vbBLNK (bit 6 of vbSTAT) is set,
; which becomes reset when through.  Blank one byte wider
; than pattern to cover shifted pictures.
;

       NOLIST
       INCLUDE "HVGLIB.H"

; ********************* Defines for Variables
; RESET   EQU     $0000

; [NORMEM + (100 lines * BYTEPL) + 1 (added since VBLANKs too wide)]
ZIGGY   EQU     $4FA1     ; VECTOR BLOCK Base Address [below screen]

; [ZVB naming convention is Ziggy Vector Block with offset value]
ZVBMR   EQU     ZIGGY+VBMR      ; 2 bytes MAGIC REGISTER and STATUS
ZVBTIMB EQU     ZIGGY+VBTIMB    ; TIME BASE
ZVBDX   EQU     ZIGGY+VBDXL     ; word DELTA X
ZVBXPOS EQU     ZIGGY+VBXL      ; word X COORD
ZVBXCHK EQU     ZIGGY+VBXCHK    ; X CHECK FLAGS
ZVBDY   EQU     ZIGGY+VBDYL     ; word DELTA Y
ZVBYPOS EQU     ZIGGY+VBYL      ; word Y COORD
ZVBYCHK EQU     ZIGGY+VBYCHK    ; Y CHECK FLAGS
ZVBOADD EQU     ZIGGY+VBOAL     ; word OLD ADDRESS OF L.O.


        LIST
        ORG     FIRSTC

; ********************* First Address in Cartridge
;
        JP      RUNFWVZ       ; AUTOSTART JMP [to RUN FWVZ]


; ********************* COLOR Table data
;
COLTAB: DB      $53           ; &(7) = RED  [Color 3 Left side]
        DB      $A3           ; &(6) = GREEN  [Color 2 Left]
        DB      $FB           ; &(5) = BLUE  [Color 1 Left]
        DB      $07           ; &(4) = WHITE  [Color 0 Left]
                              ; &(3 thru 0) = Garbage


; ********************* Vector Block LIMIT Table data
;
VLIMIT: DB      $00           ; XLL  [X limit Lower]
        DB      $87           ; XLU  [X limit Upper]
        DB      $00           ; YLL  [Y limit Lower]
        DB      $48           ; YLU  [Y limit Upper]


; ********************* "ZIGGY" Pattern data
;
PATTERN:
        DB      $00           ; X Disp. [offsets]
        DB      $00           ; Y Disp.
        DB      $03           ; X Size [in bytes]
        DB      $1C           ; Y Size
        DB      $00,$EE,$00   ; . . . . . . . . X X X . X X X . . . . . . . . .
        DB      $03,$FE,$00   ; . . . . . . X X X X X X X X X . . . . . . . . .
        DB      $0F,$9F,$80   ; . . . . X X X X X . . X X X X X X . . . . . . .
        DB      $1F,$0D,$C0   ; . . . X X X X X . . . . X X . X X X . . . . . .
        DB      $3F,$00,$C2   ; . . X X X X X X . . . . . . . . X X . . . . X .
        DB      $7E,$00,$42   ; . X X X X X X . . . . . . . . . . X . . . . X .
        DB      $FC,$8C,$E2   ; X X X X X X . . X . . . X X . . X X X . . . X .
        DB      $7D,$BE,$E2   ; . X X X X X . X X . X X X X X . X X X . . . X .
        DB      $7D,$8C,$D1   ; . X X X X X . X X . . . X X . . X X . X . . . X
        DB      $7D,$98,$51   ; . X X X X X . X X . . X X . . . . X . X . . . X
        DB      $3D,$00,$35   ; . . X X X X . X . . . . . . . . . . X X . X . X
        DB      $3D,$66,$B9   ; . . X X X X . X . X X . . X X . X . X X X . . X
        DB      $3D,$3F,$F0   ; . . X X X X . X . . X X X X X X X X X X . . . .
        DB      $3C,$8F,$C2   ; . . X X X X . . X . . . X X X X X X . . . . X .
        DB      $3C,$DF,$1E   ; . . X X X X . . X X . X X X X X . . . X X X X .
        DB      $0D,$6F,$F0   ; . . . . X X . X . X X . X X X X X X X X . . . .
        DB      $0E,$B7,$F8   ; . . . . X X X . X . X X . X X X X X X X X . . .
        DB      $00,$BF,$FB   ; . . . . . . . . X . X X X X X X X X X X X . X X
        DB      $00,$BF,$C0   ; . . . . . . . . X . X X X X X X X X . . . . . .
        DB      $03,$43,$18   ; . . . . . . X X . X . . . . X X . . . X X . . .
        DB      $1D,$40,$18   ; . . . X X X . X . X . . . . . . . . . X X . . .
        DB      $02,$40,$18   ; . . . . . . X . . X . . . . . . . . . X X . . .
        DB      $02,$00,$30   ; . . . . . . X . . . . . . . . . . . X X . . . .
        DB      $07,$00,$30   ; . . . . . X X X . . . . . . . . . . X X . . . .
        DB      $06,$E1,$F0   ; . . . . . X X . X X X . . . . X X X X X . . . .
        DB      $0C,$1E,$30   ; . . . . X X . . . . . X X X X . . . X X . . . .
        DB      $0C,$00,$70   ; . . . . X X . . . . . . . . . . . X X X . . . .
        DB      $00,$00,$60   ; . . . . . . . . . . . . . . . . . X X . . . . .


; ********************* atad Nrettap "YGGIZ"
;
NRETTAP:
        DB      $00           ; ]stesffo .psiD X[
        DB      $00           ; ].psiD Y[
        DB      $03           ; ]setyb ni[eziS X
        DB      $1C           ; eziS Y
        DB      $00,$77,$00   ; . . . . . . . . . X X X . X X X . . . . . . . .
        DB      $00,$7F,$C0   ; . . . . . . . . . X X X X X X X X X . . . . . .
        DB      $01,$F9,$F0   ; . . . . . . . X X X X X X . . X X X X X . . . .
        DB      $03,$B0,$F8   ; . . . . . . X X X . X X . . . . X X X X X . . .
        DB      $43,$00,$FC   ; . X . . . . X X . . . . . . . . X X X X X X . .
        DB      $42,$00,$7E   ; . X . . . . X . . . . . . . . . . X X X X X X .
        DB      $47,$31,$3F   ; . X . . . X X X . . X X . . . X . . X X X X X X
        DB      $47,$7D,$BE   ; . X . . . X X X . X X X X X . X X . X X X X X .
        DB      $8B,$31,$BE   ; X . . . X . X X . . X X . . . X X . X X X X X .
        DB      $8A,$19,$BE   ; X . . . X . X . . . . X X . . X X . X X X X X .
        DB      $AC,$00,$BC   ; X . X . X X . . . . . . . . . . X . X X X X . .
        DB      $9D,$66,$BC   ; X . . X X X . X . X X . . X X . X . X X X X . .
        DB      $0F,$FC,$BC   ; . . . . X X X X X X X X X X . . X . X X X X . .
        DB      $43,$F1,$3C   ; . X . . . . X X X X X X . . . X . . X X X X . .
        DB      $78,$FB,$3C   ; . X X X X . . . X X X X X . X X . . X X X X . .
        DB      $0F,$F6,$B0   ; . . . . X X X X X X X X . X X . X . X X . . . .
        DB      $1F,$ED,$70   ; . . . X X X X X X X X . X X . X . X X X . . . .
        DB      $DF,$FD,$00   ; X X . X X X X X X X X X X X . X . . . . . . . .
        DB      $03,$FD,$00   ; . . . . . . X X X X X X X X . X . . . . . . . .
        DB      $18,$C2,$C0   ; . . . X X . . . X X . . . . X . X X . . . . . .
        DB      $18,$02,$B8   ; . . . X X . . . . . . . . . X . X . X X X . . .
        DB      $18,$02,$40   ; . . . X X . . . . . . . . . X . . X . . . . . .
        DB      $0C,$00,$40   ; . . . . X X . . . . . . . . . . . X . . . . . .
        DB      $0C,$00,$E0   ; . . . . X X . . . . . . . . . . X X X . . . . .
        DB      $0F,$87,$60   ; . . . . X X X X X . . . . X X X . X X . . . . .
        DB      $0C,$78,$30   ; . . . . X X . . . X X X X . . . . . X X . . . .
        DB      $0E,$00,$30   ; . . . . X X X . . . . . . . . . . . X X . . . .
        DB      $06,$00,$00   ; . . . . . X X . . . . . . . . . . . . . . . . .


; ********************* Interrupt VECTOR jump address
;
VECTOR: DW      INTRPT        ; [address of Interrupt routine]


; ********************* Do FUN WITH VECTORS - ZIGGY starting here
;
RUNFWVZ:
        DI
        LD      SP,$5000      ; (DON'T FLUSH URINAL [at $4FFF])

        SYSSUK  COLSET        ; [COLors SET to COLor TABle]
        DW      COLTAB

        SYSSUK  FILL          ; [FILL a contiguous area to DATA's]
        DW      NORMEM        ; [starting at] SCREEN
        DW      $0FB0         ; [Count = (100 lines * BYTEPL) + 16]
        DB      $00           ; DATA

        SYSSUK  SETOUT        ; [SET some OUTports as follows:]
        DB      $C8           ; &(10) = 200  [VERBL = 100 * 2]
        DB      $2C           ; &(9) = 44  [HORCB = 176 pixels / 4]
;        DB      $0C           ; &(14) = 12  [INMOD = Screen Ints.]
    DB      $08           ; &(14) = 8  [INMOD = Screen Interrupt mode 0]

        LD      A,VECTOR / 256
        LD      I,A           ; [setting up] Int. Vector
        LD      A,VECTOR & $00FF
        OUT     (INFBK),A
        LD      A,$7F         ; &(15) = 127  [Int. Line number]
        OUT     (INLIN),A
        IM      2             ; [Interrupt Mode = Bally HVG style]

        LD      A,$08         ; &(25) = 8  [eXpand to Color 2 on 0]
        OUT     (XPAND),A

        SYSSUK  WRITP         ; [Write with Pattern Size scare-up]
        DB      $42           ; [X and Y co-ordinates]
        DB      $23
        DB      1 << MRXPND   ; [set Magic Register to 8 for EXPAND]
        DW      PATTERN+2     ; [image with Width and Height only]

        LD      (ZVBOADD),DE  ; [save Old ADDress to VBLANK]
            ; [note: initialize VBBLNK _only_ if something to blank]

        LD      HL,$C008      ; vbMR = 8  [set to EXPAND ON and ...]
            ; [(1 << VBSACT) or (1 << VBBLNK) for VECTOR ACTIVE bit]
            ; [and BLANK STATUS (see note above) loaded into vbSTAT]
        LD      (ZIGGY),HL    ; STAT = 192
        LD      A,$01         ; vbTIMB = 1 [once per Interrupt call]
        LD      (ZVBTIMB),A
        LD      HL,$4200      ; vbXpos = 66.00 [2 bytes resolution]
        LD      (ZVBXPOS),HL
        LD      A,(1 << VBCLMT) or (1 << VBCREV)  ; vbXchk = 3
            ;  [for DO LIMIT CHECKING and REVERSE DELTA ON LIMIT ATTAIN]
        LD      (ZVBXCHK),A
        LD      HL,$2300      ; vbYpos = 35.00 [2 bytes]
        LD      (ZVBYPOS),HL
        LD      (ZVBYCHK),A   ; vbYchk [= vbXchk]

LOOP:   EI                ; *** LOOP [to HERE] ***
        HALT                  ; [Wait HERE] until interrupt
        IN      A,(SW0)       ; [read &(16) for Joystick ONE]
        AND     $1F           ; [until trigger or Joystick moved ?]
            ; [actual mask is: (1 << CHUP) or (1 << CHDOWN) or ...
            ; (1 << CHLEFT) or (1 << CHRIGH) or (1 << CHTRIG) ]
        JR      Z,LOOP                  ; (-$08)

        LD      B,A           ; [hold fake SENTRY return code in B]
        BIT     CHTRIG,A      ; [choose RED on trigger in]
        JR      NZ,SKIP1
        LD      A,$04         ; &(25) = 4  [eXpand to Color 1 on 0]
        JR      SKIP2
SKIP1:  LD      A,$0C         ; &(25) = 12  [eXpand to Color 3 on 0]
SKIP2:  OUT     (XPAND),A

        SYSSUK  MSKTD         ; [returns Deltas based on Joystick in B]
        DW      $0100         ; +DeltaX = 1.00 [byte . byte]
        DB      $00           ; Flop Flag = 0  [X axis NOT reversed]
        DW      $0100         ; +DeltaY = 1.00 [2 bytes]

        LD      BC,(ZVBDY)
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC         ; [ 7 parts old delta Y ]
        SRA     H
        RR      L
        SRA     H
        RR      L
        SRA     H
        RR      L             ; [ Divide word by 8 ]
        LD      (ZVBDY),HL    ; [save +1, 0 or -1] vbDeltaY [and ...]
        EX      DE,HL
        LD      BC,(ZVBDX)
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC         ; [ 7 parts old delta X ]
        SRA     H
        RR      L
        SRA     H
        RR      L
        SRA     H
        RR      L             ; [ Divide word by 8 ]
        LD      (ZVBDX),HL    ; vbDeltaX [then ALWAYS JUMP] to LOOP
        JR      LOOP                    ; (-$19) [NOT correct value!]


; ********************* INTERRUPT ROUTINE
;
INTRPT:
        SYSSUK  VECT          ; [updates VB and returns TB used in C]
        DW      ZIGGY         ; vbMR [Vector Block base address]
        DW      VLIMIT        ; [Vector LIMIT table for bounding box]

        LD      A,C           ; [save original TB to re-set] vbTIMB
        LD      (ZVBTIMB),A   ; to RET on NO change ?
        JR      Z,INTEX                 ; (+$10) [also NOT accurate!!]

        SYSSUK  VBLANK        ; [gets old address from VB and blanks]
        DW      ZIGGY         ; vbMR [Vector Block base]
        DB      $07           ; 7 bytes W[ide]
        DB      $1C           ; 28 H[eight]

        LD      A,(ZVBDX+1)   ; [ read Delta X high byte only ]
        AND     A
        JP      P,INTP1       ; [ if Positive JumP absolute ]
        SYSSUK  VWRITR        ; [Write Relative from Vector Block]
        DW      ZIGGY         ; vbMR [base]
        DW      NRETTAP       ; [Mr. GAZ-GIZ reversed logo]
        JR      INTP2
INTP1:  SYSSUK  VWRITR        ; [Write Relative from Vector Block]
        DW      ZIGGY         ; vbMR [base]
        DW      PATTERN       ; [aka Mr. ZIG-ZAG logo]
INTP2:  EX      DE,HL
        LD      (ZVBOADD),HL  ; [save for VBLANK in] vbOADD

INTEX:  RET                   ; urn



; ********************* End of Z80 Source Code
;
                              ; $218C = End of Code